/** @file   SlimeAlien.h
 * @brief   Declaration of SlimeAlien class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/05/08 21:31:45 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_SLIMEALIEN_H
#define H_WWW_SLIMEALIEN_H

#include "Alien.h"

namespace WeWantWar {

/** @class  SlimeAlien
 * @brief   A slime alien that melts the player.
 * @author  Tomi Lamminsaari
 *
 */
class SlimeAlien : public Alien
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  SlimeAlien();

  /** Destructor
   */
  virtual ~SlimeAlien();

  /** Copy constructor
   * @param   aAnother          Reference to another SlimeAlien
   */
  SlimeAlien( const SlimeAlien& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another SlimeAlien
   * @return  Reference to this object.
   */
  SlimeAlien& operator= ( const SlimeAlien& aAnother );


  ///
  /// Inherited methods
  /// =================

  /** From GameObject.
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
   
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject.
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject.
   */
  virtual ObjectID::Type objectType() const;

  /** From Alien
   */
  virtual void attack();

  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================

  /** Sets the requested animation.
   * @param   aAnimId           Id of the animation.
   */
  virtual void setCorrectAnimation( int aAnimId );

protected:
  ///
  /// Data members
  /// ============

};

};  // end of namespace

#endif
